// Copyright (c) 2004 hijack
// Distributed under the GNU GPL v2 http://www.gnu.org/licenses/gpl.html
// Most code taken from Intel DevX at http://www.devx.com/Intel/Article/21023

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

BOOL InterceptAPI(HMODULE hLocalModule, HMODULE module, const char* c_szApiName,
        DWORD dwReplaced, DWORD dwTrampoline, int offset)
{
    int i;
    DWORD dwOldProtect;
        DWORD dwAddressToIntercept = (DWORD)GetProcAddress(
            module, (char*)c_szApiName);

    BYTE *pbTargetCode = (BYTE *) dwAddressToIntercept;
    BYTE *pbReplaced = (BYTE *) dwReplaced;
    BYTE *pbTrampoline = (BYTE *) dwTrampoline;

    // Change the protection of the trampoline region
    // so that we can overwrite the first 5 + offset bytes.
    VirtualProtect((void *) dwTrampoline, 5+offset, PAGE_WRITECOPY, &dwOldProtect);
    for (i=0;i<offset;i++)
        *pbTrampoline++ = *pbTargetCode++;
    pbTargetCode = (BYTE *) dwAddressToIntercept;

    // Insert unconditional jump in the trampoline.
    *pbTrampoline++ = 0xE9;        // jump rel32
    *((signed int *)(pbTrampoline)) = (pbTargetCode+offset) - (pbTrampoline + 4);
    VirtualProtect((void *) dwTrampoline, 5+offset, PAGE_EXECUTE, &dwOldProtect);
    
    // Overwrite the first 5 bytes of the target function
    VirtualProtect((void *) dwAddressToIntercept, 5, PAGE_WRITECOPY, &dwOldProtect);
    *pbTargetCode++ = 0xE9;        // jump rel32
    *((signed int *)(pbTargetCode)) = pbReplaced - (pbTargetCode +4);
    VirtualProtect((void *) dwAddressToIntercept, 5, PAGE_EXECUTE, &dwOldProtect);
    
    // Flush the instruction cache to make sure 
    // the modified code is executed.
    FlushInstructionCache(GetCurrentProcess(), NULL, 0);
    return TRUE;
}

BOOL InterceptAPIWithoutTrampoline(HMODULE hLocalModule,  HMODULE module,
        const char* c_szApiName, DWORD dwReplaced)
{
    DWORD dwOldProtect;
    DWORD dwAddressToIntercept = (DWORD)GetProcAddress(
            module, (char*)c_szApiName);
    BYTE *pbTargetCode = (BYTE *) dwAddressToIntercept;
    BYTE *pbReplaced = (BYTE *) dwReplaced;

    VirtualProtect((void *) dwAddressToIntercept, 5, PAGE_WRITECOPY, &dwOldProtect);
    *pbTargetCode++ = 0xE9;        // jump rel32
    *((signed int *)(pbTargetCode)) = pbReplaced - (pbTargetCode+4);
    VirtualProtect((void *) dwAddressToIntercept, 5, PAGE_EXECUTE, &dwOldProtect);

    FlushInstructionCache(GetCurrentProcess(), NULL, 0);
        return TRUE;
}

BOOL OriginalCreateProcess(
  LPCTSTR lpApplicationName,
  LPTSTR lpCommandLine,
  LPSECURITY_ATTRIBUTES lpProcessAttributes,
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  BOOL bInheritHandles,
  DWORD dwCreationFlags,
  LPVOID lpEnvironment,
  LPCTSTR lpCurrentDirectory,
  LPSTARTUPINFO lpStartupInfo,
  LPPROCESS_INFORMATION lpProcessInformation
) {
    MessageBox (0, "CreateProcess", "Original", MB_ICONINFORMATION);
    MessageBox (0, "CreateProcess", "Original", MB_ICONINFORMATION);
    MessageBox (0, "CreateProcess", "Original", MB_ICONINFORMATION);
    MessageBox (0, "CreateProcess", "Original", MB_ICONINFORMATION);
    MessageBox (0, "CreateProcess", "Original", MB_ICONINFORMATION);
    MessageBox (0, "CreateProcess", "Original", MB_ICONINFORMATION);
    MessageBox (0, "CreateProcess", "Original", MB_ICONINFORMATION);
}

BOOL ReplacedCreateProcess(
  LPCTSTR lpApplicationName,
  LPTSTR lpCommandLine,
  LPSECURITY_ATTRIBUTES lpProcessAttributes,
  LPSECURITY_ATTRIBUTES lpThreadAttributes,
  BOOL bInheritHandles,
  DWORD dwCreationFlags,
  LPVOID lpEnvironment,
  LPCTSTR lpCurrentDirectory,
  LPSTARTUPINFO lpStartupInfo,
  LPPROCESS_INFORMATION lpProcessInformation
) {
  char src[MAX_PATH];
  char *exe = strrchr(lpApplicationName, '\\');
  char *dir;
  if (exe != NULL && strcmp(exe + 1, "hl2.exe") == 0) {
    strcpy(src, lpApplicationName);
    _strlwr(src);
    dir = strstr(src, "steamapps");
    if (dir == NULL)
        MessageBox(0, "Couldn't find steamapps in path", "Hijack HL2", MB_ICONERROR);
    else
    {
        strcpy(dir, "hl2.exe");
        if (CopyFile(src, lpApplicationName, FALSE) == 0)
                MessageBox(0, "Copy failed", "Hijack HL2", MB_ICONERROR);
    }
  }
  return OriginalCreateProcess(
    lpApplicationName,
    lpCommandLine,
    lpProcessAttributes,
    lpThreadAttributes,
    bInheritHandles,
    dwCreationFlags,
    lpEnvironment,
    lpCurrentDirectory,
    lpStartupInfo,
    lpProcessInformation);
}

BOOL APIENTRY DllMain (HINSTANCE hInst     /* Library instance handle. */ ,
                       DWORD reason        /* Reason this function is being called. */ ,
                       LPVOID reserved     /* Not used. */ )
{
    HMODULE kernel32;
    switch (reason)
    {
      case DLL_PROCESS_ATTACH:
        kernel32 = GetModuleHandle((char*)"kernel32.dll");
        InterceptAPI(hInst, kernel32, "CreateProcessA",
                (DWORD)ReplacedCreateProcess,
                (DWORD)OriginalCreateProcess, 5);
        break;

      case DLL_PROCESS_DETACH:
        break;

      case DLL_THREAD_ATTACH:
        break;

      case DLL_THREAD_DETACH:
        break;
    }

    /* Returns TRUE on success, FALSE on failure */
    return TRUE;
}

