// $NO_VARIATIONS
#include "common.fx"

VS_OUTPUT vertex_shader(float4 input_position : POSITION, 
                        float4 color : COLOR0,
                        float4 color_add : COLOR1,
                        float2 uv: TEXCOORD0) {
    VS_OUTPUT output;
    output.position = mul(input_position, object_to_proj_matrix);
    output.color = color;
    output.color_add = color_add;
    output.uv = uv;
    return output;
}

sampler TextureSampler = 
sampler_state {
    Texture = <diffuse_texture>;    
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

PS_OUTPUT pixel_shader(VS_OUTPUT input) {
    PS_OUTPUT output;

    float4 texture_color = tex2D(TextureSampler, input.uv);
    output.color = input.color * texture_color + input.color_add;
    return output;
}

technique render {
    pass P0 {
        VertexShader = compile vs_1_1 vertex_shader();
        PixelShader  = compile ps_2_0 pixel_shader();

        AlphaBlendEnable = False;
        AlphaTestEnable = False;

        CullMode = None;
        ZEnable = False;
        ZWriteEnable = False;
    }
}


