#include "common.fx"

sampler DiffuseTextureSamplerClamped = 
sampler_state {
    Texture = <diffuse_texture>;    
    MipFilter = NONE;
/*
    MinFilter = LINEAR;
    MagFilter = LINEAR;
*/
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};

VS_OUTPUT vertex_shader(float4 input_position : POSITION, 
                        float4 color : COLOR0,
                        float4 color_add : COLOR1,
                        float2 uv: TEXCOORD0) {
    VS_OUTPUT output;
    output.position = mul(input_position, object_to_proj_matrix);
    output.color = color;
    output.color_add = color_add + global_color_add;
    output.uv = uv;
    prep_parallel(output);
    return output;
}

PS_OUTPUT pixel_shader(VS_OUTPUT input) {
    PS_OUTPUT output;

    float4 texture_color = tex2D(DiffuseTextureSamplerClamped, input.uv);

    output.color = apply_parallel(input.color * texture_color, input);

#ifdef MRT_REWIND
    output.color2 = 0;
    output.color2.a = output.color.a;
#endif
    return output;
}

technique render {
    pass P0 {
        VertexShader = compile vs_1_1 vertex_shader();
        PixelShader  = compile ps_2_0 pixel_shader();

        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        AlphaTestEnable = False;

        CullMode = None;
        ZEnable = False;
        ZWriteEnable = False;
    }
}


